package main.java.ui;

import main.java.rdg.Customer;
import main.java.rdg.Voucher;

import java.sql.Date;
import java.util.GregorianCalendar;

public class VoucherMenu {
    public static void run() {
        String menuStr = "" +
                "SELECT OPERATION: \n" +
                "1. Add new voucher\n" +
                "2. Find all by customer\n" +
                "3. Update voucher\n" +
                "4. Delete voucher\n" +
                "Press enter to exit";

        String input = UserInput.get(menuStr);

        switch (input){
            case "1": addVoucher(); break;
            case "2": findByCustomer(); break;
            case "3": update(); break;
            case "4": delete(); break;
            case "": break;
            default: UserInput.badInput();
        }
    }

    public static void addVoucher() {
        String[] input = UserInput.get("Enter voucher data [customer ID;voucher code;date of validity (YYYY:MM:DD);discount value (e.g. 1.25)]").split(";");

        long customerID = Long.parseLong(input[0]);

        Customer customer = Customer.read(customerID);
        if (customer == null) {
            System.out.println("No such customer ID found");
            return;
        }

        String code = input[1];
        String[] date = input[2].split(":");
        double discount = Double.parseDouble(input[3]);

        GregorianCalendar cal = new GregorianCalendar(Integer.parseInt(date[0]), Integer.parseInt(date[1])-1, Integer.parseInt(date[2]));
        Date valid = new Date(cal.getTimeInMillis());

        Voucher voucher = new Voucher();
        voucher.setCustomer(customerID);
        voucher.setCode(code);
        voucher.setValidUntil(valid);
        voucher.setDiscountValue(discount);

        UserInput.success(voucher.create());
    }

    public static void findByCustomer() {
        String input = UserInput.get("Enter customer ID");

        long customerID = Long.parseLong(input);

        Customer customer = Customer.read(customerID);
        if (customer == null) {
            System.out.println("No such customer ID found");
            return;
        }

        System.out.println(customer.getFirstName() + " " + customer.getLastName() + " {" + customerID + "} :");
        Voucher.readByCustomer(customerID).forEach(System.out::println);
    }

    public static void update () {
        String input = UserInput.get("Enter voucher ID");

        long voucherID = Long.parseLong(input);

        Voucher voucher = Voucher.read(voucherID);

        if (voucher == null){
            System.out.println("No such voucher ID found");
            return;
        }

        String bool = UserInput.get("Enter voucher state USED/AVAILABLE");

        voucher.setUsed(bool.equals("USED"));

        UserInput.success(voucher.update());
    }

    public static void delete() {
        String input = UserInput.get("Enter voucher ID");

        long voucherID = Long.parseLong(input);

        Voucher voucher = Voucher.read(voucherID);

        if (voucher == null){
            System.out.println("No such voucher ID found");
            return;
        }

        UserInput.success(voucher.delete());
    }
}
