from kafka import KafkaConsumer
from constants import KAFKA_BROKER, TEST_TOPIC, TEST_GROUP

consumer = KafkaConsumer(
    TEST_TOPIC, # more topics can be specified, e.g.,  "TOPIC1, TOPIC2," 
    group_id = TEST_GROUP,
    bootstrap_servers=KAFKA_BROKER,             
    auto_offset_reset='latest', # earliest - messages are consumed from the beginning of the topic    
    enable_auto_commit=True, # offset is commited automatically after message is consumed, relevant for consumers in consumer groups
    key_deserializer=lambda k: k.decode('utf-8') if k else None,  # deserialize keys
    value_deserializer=lambda v: v.decode('utf-8')  # deserialize values
)

print("Consumer started. Listening for messages...")

try:
    for message in consumer:
        print(f"Consumed {message.key}: {message.value}, Partition {message.partition}")
except KeyboardInterrupt:
    print("\nConsumer stopped by user.")
finally:
    consumer.close()  
    print("Consumer connection closed.")    

