from kafka import KafkaConsumer, KafkaProducer
from constants import KAFKA_BROKER, SERVER_LOGS_TOPIC, HIGH_VALUE_PURCHASES_TOPIC, HIGH_VALUE_THRESHOLD
import json

consumer = KafkaConsumer(
    SERVER_LOGS_TOPIC,
    bootstrap_servers=KAFKA_BROKER,             
    auto_offset_reset='earliest',  
    enable_auto_commit=True,
    value_deserializer=lambda x: json.loads(x.decode('utf-8'))  # deserialize values
)

producer = KafkaProducer(
    bootstrap_servers=KAFKA_BROKER,
    value_serializer=lambda x: json.dumps(x).encode('utf-8') # serialize values
)

try:
    for message in consumer:
        
        log = message.value
        
        # check if the log is a 'purchase' event and the amount is greater than threshold
        if log.get('event') == 'purchase' and log.get('amount') > HIGH_VALUE_THRESHOLD:
            
            print(f"High-value purchase detected: {log}")
            
            # send given log to HIGH_VALUE_PURCHASE_TOPIC
            producer.send(HIGH_VALUE_PURCHASES_TOPIC, value=log)
            producer.flush()
        
except KeyboardInterrupt:
    print("\nConsumer stopped by user.")
finally:
    consumer.close() 
    producer.close() 
    print("Consumer connection closed.")    

