from kafka import KafkaProducer
from constants import KAFKA_BROKER, TEST_TOPIC
import time


producer = KafkaProducer(
        bootstrap_servers=KAFKA_BROKER,
        key_serializer=lambda k: k.encode('utf-8'), # serialize keys
        value_serializer=lambda v: v.encode('utf-8')  # serialize values
     )    

try:
        i = 0
        while True:
                key = f"Key {i % 10}"
                value = f"Message {i}"
                # send is asynchronous (non-blocking) 
                # target topic is defined per message being sent
                producer.send(TEST_TOPIC, key=key, value=value)
                print(f"Produced {key}: {value}")
                time.sleep(1)  # simulate delay between messages
                i += 1        
except KeyboardInterrupt:
        print("\nProducer stopped by user.")
finally:
        # send all messages that remain in the buffer
        producer.flush()
        producer.close()
        print("Producer connection closed.")   

        


    