from kafka import KafkaProducer
from constants import KAFKA_BROKER, SERVER_LOGS_TOPIC
import time, json
from faker import Faker
import random

# initialize Faker for generating random data
faker = Faker()

# generate random server log record
def generate_server_log_record():
    event_types = ['purchase', 'login', 'logout', 'view_item', 'add_to_cart', 'remove_from_cart', 'error', 'registration']
    event = random.choice(event_types)
    
    log = {
        "event": event,
        "user_id": faker.uuid4(),  # random user ID
        "timestamp": '2012-03-07T10:52:38', # faker.iso8601(),  # random timestamp
        "item_id": faker.uuid4() if event in ['purchase', 'view_item', 'add_to_cart', 'remove_from_cart'] else None,
        "amount": round(random.uniform(10, 500), 2) if event == 'purchase' else None,
        "currency": 'EUR' if event == 'purchase' else None,
        "payment_method": random.choice(['credit_card', 'paypal', 'bank_transfer']) if event == 'purchase' else None,
        "ip_address": faker.ipv4(),  # random IP address for login, logout, etc.
        "device": random.choice(['desktop', 'mobile', 'tablet']) if event in ['login', 'logout', 'view_item'] else None,
        "category": random.choice(['electronics', 'fashion', 'home', 'books', 'toys']) if event == 'view_item' else None,
        "quantity": random.randint(1, 5) if event in ['add_to_cart', 'remove_from_cart'] else None,
        "error_code": random.choice([None, '400', '401', '403', '500']) if event == 'error' else None,
        "message": faker.text() if event == 'error' else None
    }
    
    # clean up None values from log record
    return {k: v for k, v in log.items() if v is not None}

producer = KafkaProducer(
        bootstrap_servers=KAFKA_BROKER,
        value_serializer=lambda x: json.dumps(x).encode('utf-8') # serialize values
     )    

try:        
        while True:
                value = generate_server_log_record()
                producer.send(SERVER_LOGS_TOPIC, value=value)
                print(f"Produced {value}")
                time.sleep(1)  # simulate delay between messages
                
except KeyboardInterrupt:
        print("\nProducer stopped by user.")
finally:
        producer.close()
        print("Producer connection closed.")   

        


    